/*
 * Decompiled with CFR 0.152.
 */
package net.messagevortex.blender.recipes;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Set;
import net.messagevortex.ExtendedSecureRandom;
import net.messagevortex.asn1.EncryptPayloadOperation;
import net.messagevortex.asn1.IdentityStoreBlock;
import net.messagevortex.asn1.RoutingCombo;
import net.messagevortex.blender.recipes.BlenderRecipe;
import net.messagevortex.router.Edge;
import net.messagevortex.router.GraphSet;

public class LowAnonRecipe
extends BlenderRecipe {
    long minStart = 10000L;
    long maxStart = 20000L;
    long minDelay = 20000L;
    long maxDelay = 10000L;

    public LowAnonRecipe(String section) {
    }

    @Override
    public boolean isAppliable(Set<IdentityStoreBlock> anonSet) {
        return anonSet != null && anonSet.size() <= 4;
    }

    @Override
    public RoutingCombo applyRecipe(Set<IdentityStoreBlock> anonSet, IdentityStoreBlock from, IdentityStoreBlock to) throws IOException {
        ArrayList<IdentityStoreBlock> set = new ArrayList<IdentityStoreBlock>();
        set.add(to);
        set.addAll(anonSet);
        int[] order = new int[set.size()];
        GraphSet g = new GraphSet();
        IdentityStoreBlock fb = from;
        for (int i = 0; i < order.length; ++i) {
            int ni = ExtendedSecureRandom.nextInt(order.length - i);
            for (int j = i - 1; j > 0; --j) {
                if (order[j] > ni) continue;
                ++ni;
            }
            order[i] = ni;
            g.add(new Edge(fb, (IdentityStoreBlock)set.get(ni), this.minStart + (long)ExtendedSecureRandom.nextInt((int)(this.maxStart - this.minStart)), this.minDelay + (long)ExtendedSecureRandom.nextInt((int)(this.maxDelay - this.minDelay))));
            fb = (IdentityStoreBlock)set.get(ni);
        }
        RoutingCombo rb = new RoutingCombo();
        int targetBlock = ExtendedSecureRandom.nextInt(1024, 65737);
        rb.addOperation(new EncryptPayloadOperation(0, targetBlock, null));
        return null;
    }
}

