/*
 * Decompiled with CFR 0.152.
 */
package net.messagevortex.transport;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.channels.SocketChannel;
import java.util.logging.Logger;
import javax.net.ssl.SSLEngine;
import net.messagevortex.MessageVortexLogger;
import net.messagevortex.transport.AbstractConnection;
import net.messagevortex.transport.SecurityContext;

public class ClientConnection
extends AbstractConnection {
    private static final Logger LOGGER = MessageVortexLogger.getLogger(new Throwable().getStackTrace()[0].getClassName());

    public ClientConnection(SocketChannel channel, SecurityContext context) {
        super(channel, context);
        this.initConnection();
    }

    public ClientConnection(InetSocketAddress socketAddress, SecurityContext context) {
        super(socketAddress, context);
        this.initConnection();
    }

    private void initConnection() {
        if (this.getSecurityContext() != null && this.getSecurityContext().getContext() != null) {
            SSLEngine engine = this.getSecurityContext().getContext().createSSLEngine(this.getHostName(), this.getPort());
            engine.setUseClientMode(true);
            this.setEngine(engine);
        }
    }

    @Override
    public void shutdown() throws IOException {
        super.shutdown();
        this.closeConnection();
    }
}

