/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.cache.impl.operation;

import com.hazelcast.cache.impl.operation.KeyBasedCacheOperation;
import com.hazelcast.internal.iteration.IterationPointer;
import com.hazelcast.internal.serialization.impl.HeapData;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.spi.impl.operationservice.ReadonlyOperation;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;

public class CacheFetchKeysOperation
extends KeyBasedCacheOperation
implements ReadonlyOperation {
    private IterationPointer[] pointers;
    private int fetchSize;

    public CacheFetchKeysOperation() {
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP2"}, justification="This is an internal class")
    public CacheFetchKeysOperation(String name, IterationPointer[] pointers, int fetchSize) {
        super(name, new HeapData());
        this.pointers = pointers;
        this.fetchSize = fetchSize;
    }

    @Override
    public int getClassId() {
        return 22;
    }

    @Override
    public void run() throws Exception {
        this.response = this.recordStore.fetchKeys(this.pointers, this.fetchSize);
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeInt(this.pointers.length);
        for (IterationPointer pointer : this.pointers) {
            out.writeInt(pointer.getIndex());
            out.writeInt(pointer.getSize());
        }
        out.writeInt(this.fetchSize);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        int pointersCount = in.readInt();
        this.pointers = new IterationPointer[pointersCount];
        for (int i2 = 0; i2 < pointersCount; ++i2) {
            this.pointers[i2] = new IterationPointer(in.readInt(), in.readInt());
        }
        this.fetchSize = in.readInt();
    }
}

