/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.everit.json.schema.internal;

import com.hazelcast.shaded.org.everit.json.schema.FormatValidator;
import com.hazelcast.shaded.org.everit.json.schema.JSONPointer;
import java.util.Optional;

public class JsonPointerFormatValidator
implements FormatValidator {
    @Override
    public Optional<String> validate(String subject) {
        if ("".equals(subject)) {
            return Optional.empty();
        }
        try {
            new JSONPointer(subject);
            if (subject.startsWith("#")) {
                return this.failure(subject);
            }
            return this.checkEscaping(subject);
        }
        catch (IllegalArgumentException e) {
            return this.failure(subject);
        }
    }

    protected Optional<String> failure(String subject) {
        return Optional.of(String.format("[%s] is not a valid JSON pointer", subject));
    }

    protected Optional<String> checkEscaping(String subject) {
        for (int i2 = 0; i2 < subject.length() - 1; ++i2) {
            char next;
            char c = subject.charAt(i2);
            if (c != '~' || (next = subject.charAt(i2 + 1)) == '1' || next == '0') continue;
            return this.failure(subject);
        }
        if (subject.charAt(subject.length() - 1) == '~') {
            return this.failure(subject);
        }
        return Optional.empty();
    }

    @Override
    public String formatName() {
        return "json-pointer";
    }
}

