/*
 * Decompiled with CFR 0.152.
 */
package net.messagevortex.asn1;

import java.io.IOException;
import java.io.Serializable;
import java.security.Security;
import net.messagevortex.asn1.AbstractBlock;
import net.messagevortex.asn1.AlgorithmParameter;
import net.messagevortex.asn1.encryption.Algorithm;
import net.messagevortex.asn1.encryption.DumpType;
import net.messagevortex.asn1.encryption.Parameter;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Enumerated;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public abstract class Key
extends AbstractBlock
implements Serializable {
    public static final long serialVersionUID = 100000000009L;
    AlgorithmParameter parameters = new AlgorithmParameter();

    void parseKeyParameter(ASN1Sequence s) throws IOException {
        Algorithm alg = Algorithm.getById(ASN1Enumerated.getInstance(s.getObjectAt(0)).getValue().intValue());
        this.parameters = new AlgorithmParameter(s.getObjectAt(1));
        this.parameters.put(Parameter.ALGORITHM.getId(), alg.toString());
    }

    ASN1Encodable encodeKeyParameter(DumpType dumpType) throws IOException {
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add(new ASN1Enumerated(Algorithm.getByString(this.parameters.get(Parameter.ALGORITHM.getId())).getId()));
        v.add(this.parameters.toAsn1Object(dumpType));
        return new DERSequence(v);
    }

    String dumpKeyTypeValueNotation(String prefix, DumpType dumpType) {
        StringBuilder sb = new StringBuilder();
        sb.append(prefix).append("keyType ").append(Algorithm.getByString(this.parameters.get(Parameter.ALGORITHM.getId()))).append(',').append("\r\n");
        sb.append(prefix).append("parameter ").append(this.parameters.dumpValueNotation(prefix, dumpType));
        return sb.toString();
    }

    public abstract byte[] decrypt(byte[] var1) throws IOException;

    public abstract byte[] encrypt(byte[] var1) throws IOException;

    static {
        Security.addProvider(new BouncyCastleProvider());
    }
}

