/*
 * Decompiled with CFR 0.152.
 */
package net.messagevortex.asn1;

import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.messagevortex.MessageVortexLogger;
import net.messagevortex.asn1.AbstractBlock;
import net.messagevortex.asn1.AsymmetricKey;
import net.messagevortex.asn1.InnerMessageBlock;
import net.messagevortex.asn1.PrefixBlock;
import net.messagevortex.asn1.SymmetricKey;
import net.messagevortex.asn1.encryption.DumpType;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERTaggedObject;

public class VortexMessage
extends AbstractBlock
implements Serializable {
    public static final long serialVersionUID = 100000000018L;
    public static final int PREFIX_PLAIN = 10011;
    public static final int PREFIX_ENCRYPTED = 10012;
    public static final int INNER_MESSAGE_PLAIN = 10021;
    public static final int INNER_MESSAGE_ENCRYPTED = 10022;
    private PrefixBlock prefix;
    private InnerMessageBlock innerMessage;
    private AsymmetricKey decryptionKey;
    private static final Logger LOGGER = MessageVortexLogger.getLogger(new Exception().getStackTrace()[0].getClassName());

    private VortexMessage() throws IOException {
        this.prefix = new PrefixBlock();
        this.innerMessage = new InnerMessageBlock();
        this.decryptionKey = null;
    }

    public VortexMessage(InputStream is, AsymmetricKey dk) throws IOException {
        this.setDecryptionKey(dk);
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        byte[] chunk = new byte[0x100000];
        int i2 = is.read(chunk, 0, chunk.length - 1);
        while (i2 > 0) {
            buffer.write(chunk, 0, i2);
            i2 = is.read(chunk, 0, chunk.length - 1);
        }
        try {
            this.parse(buffer.toByteArray());
        }
        catch (EOFException | IllegalArgumentException eex) {
            throw new IOException("Exception while parsing byte array", eex);
        }
        buffer.close();
    }

    public VortexMessage(byte[] b, AsymmetricKey dk) throws IOException {
        this.setDecryptionKey(dk);
        this.parse(b);
    }

    public VortexMessage(PrefixBlock pre, InnerMessageBlock im) throws IOException {
        this();
        if (pre == null) {
            this.setPrefix(new PrefixBlock(new SymmetricKey()));
        } else {
            this.setPrefix(pre);
        }
        this.setInnerMessage(im);
    }

    public final InnerMessageBlock getInnerMessage() {
        return this.innerMessage;
    }

    public final InnerMessageBlock setInnerMessage(InnerMessageBlock im) {
        if (im == null) {
            throw new NullPointerException("InnerMessage may not be null");
        }
        InnerMessageBlock old = this.getInnerMessage();
        this.innerMessage = im;
        return old;
    }

    public final PrefixBlock getPrefix() {
        return this.prefix;
    }

    public final PrefixBlock setPrefix(PrefixBlock pre) {
        if (pre == null) {
            throw new NullPointerException("Prefix may not be null");
        }
        PrefixBlock old = this.getPrefix();
        this.prefix = pre;
        return old;
    }

    public final AsymmetricKey getDecryptionKey() {
        return this.decryptionKey;
    }

    public final AsymmetricKey setDecryptionKey(AsymmetricKey dk) throws IOException {
        AsymmetricKey newOld;
        AsymmetricKey old = this.decryptionKey;
        AsymmetricKey asymmetricKey = this.decryptionKey = dk != null ? new AsymmetricKey(dk) : null;
        if (this.prefix != null && (newOld = this.prefix.setDecryptionKey(dk)) != null) {
            old = newOld;
        }
        if (this.innerMessage != null && this.innerMessage.getPrefix() != null && (newOld = this.innerMessage.getPrefix().setDecryptionKey(dk)) != null) {
            old = newOld;
        }
        return old;
    }

    @Override
    protected final void parse(byte[] p) throws IOException {
        try (ASN1InputStream asnIn = new ASN1InputStream(p);){
            this.parse(asnIn.readObject());
        }
    }

    protected void parse(InputStream is) throws IOException {
        try (ASN1InputStream asnIn = new ASN1InputStream(is);){
            this.parse(asnIn.readObject());
        }
    }

    @Override
    protected void parse(ASN1Encodable p) throws IOException {
        if (p == null) {
            throw new NullPointerException("Encodable may not be null");
        }
        LOGGER.log(Level.FINER, "Executing parse()");
        int i2 = 0;
        ASN1Sequence s1 = ASN1Sequence.getInstance(p);
        ASN1TaggedObject to = ASN1TaggedObject.getInstance(s1.getObjectAt(i2));
        ++i2;
        switch (to.getTagNo()) {
            case 10011: {
                LOGGER.log(Level.INFO, "parsing unencrypted/plain prefix block");
                this.prefix = new PrefixBlock(to.getBaseObject().toASN1Primitive(), null);
                break;
            }
            case 10012: {
                LOGGER.log(Level.INFO, "parsing encrypted prefix block");
                this.prefix = new PrefixBlock(ASN1OctetString.getInstance(to.getBaseObject()).getOctets(), this.getDecryptionKey());
                break;
            }
            default: {
                throw new IOException("got unexpected tag number when reading prefix (" + to.getTagNo() + ")");
            }
        }
        if (this.prefix == null) {
            throw new IOException("unable to parse prefix block");
        }
        to = ASN1TaggedObject.getInstance(s1.getObjectAt(i2));
        ++i2;
        switch (to.getTagNo()) {
            case 10021: {
                this.innerMessage = new InnerMessageBlock(VortexMessage.toDer(to.getBaseObject()), null);
                break;
            }
            case 10022: {
                if (this.prefix.getKey() == null) {
                    throw new IOException("unable to get key from prefix block");
                }
                byte[] stream = null;
                try {
                    byte[] derStream = ASN1OctetString.getInstance(to.getBaseObject()).getOctets();
                    stream = this.prefix.getKey().decrypt(derStream);
                }
                catch (IllegalArgumentException iae) {
                    throw new IOException("unable to get decrypted byte stream (1)", iae);
                }
                if (stream == null || stream.length == 0) {
                    throw new IOException("unable to get decrypted byte stream (2; stream is null or sized 0 bytes)");
                }
                this.innerMessage = new InnerMessageBlock(stream, this.getDecryptionKey());
                break;
            }
            default: {
                throw new IOException("got unexpected tag number when reading inner message (" + to.getTagNo() + ")");
            }
        }
        this.setDecryptionKey(this.getDecryptionKey());
    }

    @Override
    public ASN1Object toAsn1Object(DumpType dt) throws IOException {
        LOGGER.log(Level.FINER, "Executing toAsn1Object()");
        ASN1EncodableVector v = new ASN1EncodableVector();
        this.addPrefixBlockToAsn1(v, dt);
        this.addInnerMessageBlockToAsn1(v, dt);
        DERSequence seq = new DERSequence(v);
        LOGGER.log(Level.FINER, "done toAsn1Object()");
        return seq;
    }

    private void addPrefixBlockToAsn1(ASN1EncodableVector v, DumpType dumpType) throws IOException {
        ASN1Object o = this.getPrefix().toAsn1Object(dumpType);
        if (o == null) {
            throw new IOException("returned prefix object may not be null");
        }
        if (dumpType == DumpType.ALL_UNENCRYPTED || this.getPrefix().getDecryptionKey() == null) {
            LOGGER.log(Level.INFO, "Adding unencrypted prefix block to message");
            v.add(new DERTaggedObject(10011, o));
        } else {
            LOGGER.log(Level.INFO, "Adding encrypted prefix block to message");
            v.add(new DERTaggedObject(10012, new DEROctetString(this.getPrefix().toEncBytes())));
        }
    }

    private void addInnerMessageBlockToAsn1(ASN1EncodableVector v, DumpType dt) throws IOException {
        if (this.prefix.getKey() == null || DumpType.ALL_UNENCRYPTED == dt) {
            LOGGER.log(Level.INFO, "Adding unencrypted inner message block to message");
            v.add(new DERTaggedObject(10021, this.getInnerMessage().toAsn1Object(dt)));
        } else {
            LOGGER.log(Level.INFO, "Adding encrypted inner message block to message");
            byte[] b = VortexMessage.toDer(this.getInnerMessage().toAsn1Object(dt));
            v.add(new DERTaggedObject(10022, new DEROctetString(this.prefix.getKey().encrypt(b))));
        }
    }

    public String dumpValueNotation(String prefix) throws IOException {
        return this.dumpValueNotation(prefix, DumpType.PUBLIC_ONLY);
    }

    @Override
    public String dumpValueNotation(String prefix, DumpType dt) throws IOException {
        StringBuilder ret = new StringBuilder();
        ret.append(prefix).append("m VortexMessage ::= {").append("\r\n");
        ret.append(prefix).append("  -- Dumping prefix").append("\r\n");
        ret.append(prefix).append("  prefix ").append(this.getPrefix().dumpValueNotation(prefix + "  ", dt)).append(',').append("\r\n");
        ret.append(prefix).append("  -- Dumping innerMessage").append("\r\n");
        ret.append(prefix).append("  innerMessage ").append(this.getInnerMessage().dumpValueNotation(prefix + "  ", dt)).append(',').append("\r\n");
        ret.append(prefix).append('}').append("\r\n");
        return ret.toString();
    }

    public byte[] toBinary(DumpType dt) throws IOException {
        return this.toAsn1Object(dt).getEncoded();
    }

    public static byte[] getLongAsBytes(long i2, int num) {
        byte[] ret = new byte[num];
        for (int j = 0; j < num; ++j) {
            ret[j] = (byte)(i2 >> j * 8 & 0xFFL);
        }
        return ret;
    }

    public static byte[] getLongAsBytes(long i2) {
        return VortexMessage.getLongAsBytes(i2, 4);
    }

    public static long getBytesAsLong(byte[] b) {
        if (b == null || b.length < 1 || b.length > 8) {
            throw new IllegalArgumentException("byte array must contain exactly four bytes");
        }
        long ret = 0L;
        for (int i2 = 0; i2 < b.length; ++i2) {
            ret |= (long)(b[i2] & 0xFF) << i2 * 8;
        }
        return ret;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o.getClass() != this.getClass()) {
            return false;
        }
        VortexMessage vm = (VortexMessage)o;
        try {
            return Arrays.equals(vm.toBytes(DumpType.ALL_UNENCRYPTED), this.toBytes(DumpType.ALL_UNENCRYPTED));
        }
        catch (IOException ioe) {
            return false;
        }
    }

    public int hashCode() {
        try {
            return this.prepareDump(this.dumpValueNotation("", DumpType.ALL_UNENCRYPTED)).hashCode();
        }
        catch (IOException ioe) {
            return -1;
        }
    }
}

