/*
 * Decompiled with CFR 0.152.
 */
package net.messagevortex.router.operation;

import java.io.Serializable;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.messagevortex.MessageVortexLogger;
import net.messagevortex.router.operation.AbstractOperation;

public class IdMapOperation
extends AbstractOperation
implements Serializable {
    public static final long serialVersionUID = 100000000019L;
    private static final transient Logger LOGGER = MessageVortexLogger.getLogger(new Throwable().getStackTrace()[0].getClassName());
    private final int[] outputId;
    private final int[] inputId;

    public IdMapOperation(int sourceId, int targetId, int number) {
        this.inputId = new int[number];
        this.outputId = new int[number];
        for (int i2 = 0; i2 < this.inputId.length; ++i2) {
            this.inputId[i2] = sourceId + i2;
            this.outputId[i2] = targetId + i2;
        }
    }

    @Override
    public int[] getOutputId() {
        return (int[])this.outputId.clone();
    }

    @Override
    public int[] getInputId() {
        return (int[])this.inputId.clone();
    }

    @Override
    public boolean canRun() {
        return true;
    }

    @Override
    public int[] execute(int[] id) {
        LOGGER.log(Level.INFO, "running IDMapper " + this.inputId[0] + "/" + this.outputId[0] + "/" + this.inputId.length);
        for (int i2 = 0; i2 < this.inputId.length; ++i2) {
            this.payload.setCalculatedPayload(this.outputId[i2], this.payload.getPayload(this.inputId[i2]));
        }
        return this.getOutputId();
    }

    public String toString() {
        return this.inputId[0] + "->IdMapper(" + this.inputId.length + ")->" + this.outputId[0];
    }
}

