/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shared.jar.identification.exposers;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.List;
import java.util.jar.JarEntry;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.model.Model;
import org.apache.maven.model.Organization;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import org.apache.maven.shared.jar.JarAnalyzer;
import org.apache.maven.shared.jar.identification.JarIdentification;
import org.apache.maven.shared.jar.identification.JarIdentificationExposer;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
@Named(value="embeddedMavenModel")
public class EmbeddedMavenModelExposer
implements JarIdentificationExposer {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    @Override
    public void expose(JarIdentification identification, JarAnalyzer jarAnalyzer) {
        List<JarEntry> entries = jarAnalyzer.getMavenPomEntries();
        if (entries.isEmpty()) {
            return;
        }
        if (entries.size() > 1) {
            this.logger.warn("More than one Maven model entry was found in the JAR, using only the first of: " + entries);
        }
        JarEntry pom = entries.get(0);
        MavenXpp3Reader pomreader = new MavenXpp3Reader();
        try (InputStream is = jarAnalyzer.getEntryInputStream(pom);
             InputStreamReader isreader = new InputStreamReader(is);){
            Organization org;
            Model model = pomreader.read(isreader);
            if (model.getParent() != null) {
                if (model.getGroupId() == null) {
                    identification.addAndSetGroupId(model.getParent().getGroupId());
                }
                if (model.getVersion() == null) {
                    identification.addAndSetVersion(model.getParent().getVersion());
                }
            }
            identification.addAndSetGroupId(model.getGroupId());
            identification.addAndSetArtifactId(model.getArtifactId());
            identification.addAndSetVersion(model.getVersion());
            identification.addAndSetName(model.getName());
            if (model.getName() == null) {
                identification.addAndSetName(model.getArtifactId());
            }
            if ((org = model.getOrganization()) != null) {
                identification.addAndSetVendor(org.getName());
            }
        }
        catch (IOException e) {
            this.logger.error("Unable to read model " + pom.getName() + " in " + jarAnalyzer.getFile() + ".", e);
        }
        catch (XmlPullParserException e) {
            this.logger.error("Unable to parse model " + pom.getName() + " in " + jarAnalyzer.getFile() + ".", e);
        }
    }
}

