/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shared.jar.identification.exposers;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.jar.JarEntry;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.collections4.bag.HashBag;
import org.apache.maven.shared.jar.JarAnalyzer;
import org.apache.maven.shared.jar.identification.JarIdentification;
import org.apache.maven.shared.jar.identification.JarIdentificationExposer;

@Singleton
@Named(value="timestamp")
public class TimestampExposer
implements JarIdentificationExposer {
    @Override
    public void expose(JarIdentification identification, JarAnalyzer jarAnalyzer) {
        List<JarEntry> entries = jarAnalyzer.getEntries();
        SimpleDateFormat tsformat = new SimpleDateFormat("yyyyMMdd", Locale.US);
        HashBag<String> timestamps = new HashBag<String>();
        for (JarEntry entry : entries) {
            long time = entry.getTime();
            String timestamp = tsformat.format(new Date(time));
            timestamps.add(timestamp);
        }
        String ts = "";
        int tsmax = 0;
        for (String timestamp : timestamps) {
            int count = timestamps.getCount(timestamp);
            if (count <= tsmax) continue;
            ts = timestamp;
            tsmax = count;
        }
        if (ts != null && !ts.isEmpty()) {
            identification.addVersion(ts);
        }
    }
}

