/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shared.utils.xml;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.WillClose;
import org.apache.maven.shared.utils.xml.Xpp3Dom;
import org.apache.maven.shared.utils.xml.pull.XmlPullParserException;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

public class Xpp3DomBuilder {
    public static Xpp3Dom build(@WillClose @Nonnull Reader reader) throws XmlPullParserException {
        return Xpp3DomBuilder.build(reader, false);
    }

    public static Xpp3Dom build(@WillClose InputStream is, @Nonnull String encoding) throws XmlPullParserException {
        return Xpp3DomBuilder.build(is, encoding, false);
    }

    @Deprecated
    public static Xpp3Dom build(@WillClose InputStream is, @Nonnull String encoding, boolean noop) throws XmlPullParserException {
        try {
            InputStreamReader reader = new InputStreamReader(is, encoding);
            return Xpp3DomBuilder.build(reader);
        }
        catch (UnsupportedEncodingException e) {
            throw new XmlPullParserException(e);
        }
    }

    @Deprecated
    public static Xpp3Dom build(@WillClose Reader in, boolean noop) throws XmlPullParserException {
        Xpp3Dom xpp3Dom;
        block8: {
            Reader reader = in;
            try {
                DocHandler docHandler = Xpp3DomBuilder.parseSax(new InputSource(reader));
                reader.close();
                xpp3Dom = docHandler.result;
                if (reader == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new XmlPullParserException(e);
                }
            }
            reader.close();
        }
        return xpp3Dom;
    }

    private static DocHandler parseSax(@Nonnull InputSource inputSource) throws XmlPullParserException {
        try {
            DocHandler ch = new DocHandler();
            XMLReader parser = Xpp3DomBuilder.createXmlReader();
            parser.setContentHandler(ch);
            parser.parse(inputSource);
            return ch;
        }
        catch (IOException e) {
            throw new XmlPullParserException(e);
        }
        catch (SAXException e) {
            throw new XmlPullParserException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static XMLReader createXmlReader() throws SAXException {
        XMLReader comSunXmlReader = Xpp3DomBuilder.instantiate("com.sun.org.apache.xerces.internal.parsers.SAXParser");
        if (comSunXmlReader != null) {
            return comSunXmlReader;
        }
        String key = "org.xml.sax.driver";
        String oldParser = System.getProperty(key);
        System.clearProperty(key);
        try {
            XMLReader xMLReader = XMLReaderFactory.createXMLReader();
            return xMLReader;
        }
        finally {
            if (oldParser != null) {
                System.setProperty(key, oldParser);
            }
        }
    }

    private static XMLReader instantiate(String s) {
        try {
            Class<?> aClass = Thread.currentThread().getContextClassLoader().loadClass(s);
            return (XMLReader)aClass.newInstance();
        }
        catch (ClassNotFoundException e) {
            return null;
        }
        catch (InstantiationException e) {
            return null;
        }
        catch (IllegalAccessException e) {
            return null;
        }
    }

    private static class DocHandler
    extends DefaultHandler {
        private final List<Xpp3Dom> elemStack = new ArrayList<Xpp3Dom>();
        private final List<StringBuilder> values = new ArrayList<StringBuilder>();
        Xpp3Dom result = null;
        private boolean spacePreserve = false;

        private DocHandler() {
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            this.spacePreserve = false;
            Xpp3Dom child = new Xpp3Dom(localName);
            this.attachToParent(child);
            this.pushOnStack(child);
            this.values.add(new StringBuilder());
            int size = attributes.getLength();
            for (int i2 = 0; i2 < size; ++i2) {
                String name = attributes.getQName(i2);
                String value = attributes.getValue(i2);
                child.setAttribute(name, value);
                this.spacePreserve = this.spacePreserve || "xml:space".equals(name) && "preserve".equals(value);
            }
        }

        private boolean pushOnStack(Xpp3Dom child) {
            return this.elemStack.add(child);
        }

        private void attachToParent(Xpp3Dom child) {
            int depth = this.elemStack.size();
            if (depth > 0) {
                this.elemStack.get(depth - 1).addChild(child);
            }
        }

        private Xpp3Dom pop() {
            int depth = this.elemStack.size() - 1;
            return this.elemStack.remove(depth);
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            int depth = this.elemStack.size() - 1;
            Xpp3Dom element = this.pop();
            StringBuilder accumulatedValue = this.values.remove(depth);
            if (element.getChildCount() == 0) {
                if (accumulatedValue == null) {
                    element.setValue("");
                } else {
                    element.setValue(((Object)accumulatedValue).toString());
                }
            }
            if (depth == 0) {
                this.result = element;
            }
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            String text = new String(ch, start, length);
            this.appendToTopValue(text);
        }

        private void appendToTopValue(String toAppend) {
            StringBuilder stringBuilder = this.values.get(this.values.size() - 1);
            stringBuilder.append(toAppend);
        }
    }
}

