/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.installer.bootstrap;

import com.izforge.izpack.api.data.AutomatedInstallData;
import com.izforge.izpack.api.data.Overrides;
import com.izforge.izpack.core.data.DefaultOverrides;
import com.izforge.izpack.core.data.DefaultVariables;
import com.izforge.izpack.installer.automation.AutomatedInstaller;
import com.izforge.izpack.installer.bootstrap.InstallerConsole;
import com.izforge.izpack.installer.bootstrap.InstallerGui;
import com.izforge.izpack.installer.console.ConsoleInstallerAction;
import com.izforge.izpack.installer.container.impl.AutomatedInstallerContainer;
import com.izforge.izpack.logging.FileFormatter;
import com.izforge.izpack.util.Debug;
import com.izforge.izpack.util.LogUtils;
import com.izforge.izpack.util.StringTool;
import java.awt.GraphicsEnvironment;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Properties;
import java.util.logging.ConsoleHandler;
import java.util.logging.FileHandler;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.io.FilenameUtils;

public class Installer {
    private static Logger logger = Logger.getLogger(Installer.class.getName());
    public static final int INSTALLER_GUI = 0;
    public static final int INSTALLER_AUTO = 1;
    public static final int INSTALLER_CONSOLE = 2;
    private static int installerMode = 0;

    public static void main(String[] args) {
        try {
            Installer installer = new Installer();
            installer.start(args);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void initializeLogging(String logFileName) throws IOException {
        if (logFileName != null) {
            Properties props = new Properties();
            String cname = FileHandler.class.getName();
            props.setProperty("handlers", cname);
            props.setProperty(cname + ".pattern", FilenameUtils.normalize(logFileName));
            props.setProperty(cname + ".formatter", FileFormatter.class.getName());
            props.setProperty(ConsoleHandler.class.getName() + ".level", "OFF");
            props.setProperty(".level", "OFF");
            LogUtils.loadConfiguration(props);
        } else {
            LogUtils.loadConfiguration();
        }
        logger = Logger.getLogger(Installer.class.getName());
    }

    private static String fetchArgument(Iterator<String> iterator, String prev) throws IllegalArgumentException {
        if (prev != null) {
            throw new IllegalArgumentException("Option used twice or in an ambiguous combination");
        }
        String next = null;
        if (iterator.hasNext()) {
            next = iterator.next().trim();
        }
        return next;
    }

    private static void checkPath(String arg) throws IllegalArgumentException {
        if (arg == null) {
            throw new IllegalArgumentException("Option must be followed by a path");
        }
    }

    private void start(String[] args) {
        if (System.getProperty("mrj.version") != null) {
            System.setProperty("com.apple.mrj.application.apple.menu.about.name", "IzPack");
            System.setProperty("com.apple.mrj.application.growbox.intrudes", "false");
            System.setProperty("com.apple.mrj.application.live-resize", "true");
        }
        try {
            Iterator<String> args_it = Arrays.asList(args).iterator();
            int type = 0;
            ConsoleInstallerAction consoleAction = ConsoleInstallerAction.CONSOLE_INSTALL;
            String path = null;
            String langcode = null;
            String media = null;
            String defaultsFile = null;
            String logFileName = null;
            while (args_it.hasNext()) {
                String arg = args_it.next().trim();
                try {
                    if ("-logfile".equalsIgnoreCase(arg)) {
                        logFileName = Installer.fetchArgument(args_it, logFileName);
                        Installer.checkPath(logFileName);
                        continue;
                    }
                    if ("-debug".equalsIgnoreCase(arg)) {
                        Debug.setDEBUG(true);
                        continue;
                    }
                    if ("-trace".equalsIgnoreCase(arg)) {
                        Debug.setTRACE(true);
                        continue;
                    }
                    if ("-stacktrace".equalsIgnoreCase(arg)) {
                        Debug.setSTACKTRACE(true);
                        continue;
                    }
                    if ("-console".equalsIgnoreCase(arg)) {
                        type = 2;
                        continue;
                    }
                    if ("-auto".equalsIgnoreCase(arg)) {
                        type = 1;
                        continue;
                    }
                    if ("-defaults-file".equalsIgnoreCase(arg)) {
                        defaultsFile = Installer.fetchArgument(args_it, defaultsFile);
                        Installer.checkPath(defaultsFile);
                        continue;
                    }
                    if ("-options-template".equalsIgnoreCase(arg)) {
                        path = Installer.fetchArgument(args_it, path);
                        Installer.checkPath(path);
                        type = 2;
                        consoleAction = ConsoleInstallerAction.CONSOLE_GEN_TEMPLATE;
                        continue;
                    }
                    if ("-options".equalsIgnoreCase(arg)) {
                        path = Installer.fetchArgument(args_it, path);
                        Installer.checkPath(path);
                        type = 2;
                        consoleAction = ConsoleInstallerAction.CONSOLE_FROM_TEMPLATE;
                        continue;
                    }
                    if ("-options-system".equalsIgnoreCase(arg)) {
                        type = 2;
                        consoleAction = ConsoleInstallerAction.CONSOLE_FROM_SYSTEMPROPERTIES;
                        continue;
                    }
                    if ("-options-auto".equalsIgnoreCase(arg)) {
                        path = Installer.fetchArgument(args_it, path);
                        Installer.checkPath(path);
                        type = 2;
                        consoleAction = ConsoleInstallerAction.CONSOLE_FROM_SYSTEMPROPERTIESMERGE;
                        continue;
                    }
                    if ("-language".equalsIgnoreCase(arg)) {
                        if ((langcode = Installer.fetchArgument(args_it, langcode)) != null && !langcode.startsWith("-")) continue;
                        throw new IllegalArgumentException("Option must be followed by a language code");
                    }
                    if ("-media".equalsIgnoreCase(arg)) {
                        media = Installer.fetchArgument(args_it, media);
                        Installer.checkPath(media);
                        continue;
                    }
                    type = 1;
                    path = arg;
                }
                catch (IllegalArgumentException e) {
                    logger.severe("Wrong usage of command line argument \"" + arg + "\": " + e.getMessage());
                    System.exit(1);
                }
            }
            Installer.initializeLogging(logFileName);
            if (args.length != 0) {
                logger.info("Command line arguments: " + StringTool.stringArrayToSpaceSeparatedString(args));
            }
            Overrides defaults = this.getDefaults(defaultsFile);
            this.launchInstall(type, consoleAction, path, langcode, media, defaults, args);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
            System.exit(1);
        }
    }

    public Overrides getDefaults(String path) throws IOException {
        File overridePropFile = null;
        if (path != null) {
            overridePropFile = new File(path);
        } else {
            try {
                File jarFile = new File(DefaultVariables.class.getProtectionDomain().getCodeSource().getLocation().toURI().getPath());
                String jarDir = jarFile.getParentFile().getPath();
                overridePropFile = new File(jarDir, FilenameUtils.getBaseName(jarFile.getPath()) + ".defaults");
                if (!overridePropFile.exists()) {
                    overridePropFile = null;
                }
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
        if (overridePropFile != null) {
            return new DefaultOverrides(overridePropFile);
        }
        return null;
    }

    private void launchInstall(int type, ConsoleInstallerAction consoleAction, String path, String langCode, String mediaDir, Overrides defaults, String[] args) throws Exception {
        if (type == 0 && GraphicsEnvironment.isHeadless()) {
            type = 2;
        }
        installerMode = type;
        switch (type) {
            case 0: {
                InstallerGui.run(langCode, mediaDir, defaults);
                break;
            }
            case 1: {
                this.launchAutomatedInstaller(path, mediaDir, defaults, args);
                break;
            }
            case 2: {
                InstallerConsole.run(consoleAction, path, langCode, mediaDir, defaults, args);
            }
        }
    }

    private void launchAutomatedInstaller(String path, String mediaDir, Overrides defaults, String[] args) throws Exception {
        AutomatedInstallerContainer container = new AutomatedInstallerContainer();
        if (defaults != null) {
            defaults.setInstallData(container.getComponent(AutomatedInstallData.class));
            defaults.load();
            logger.info("Loaded " + defaults.size() + " override(s) from " + defaults.getFile());
            DefaultVariables variables = container.getComponent(DefaultVariables.class);
            variables.setOverrides(defaults);
        }
        AutomatedInstaller automatedInstaller = container.getComponent(AutomatedInstaller.class);
        automatedInstaller.init(path, mediaDir, args);
        automatedInstaller.doInstall();
    }

    public static int getInstallerMode() {
        return installerMode;
    }
}

