/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.protocol.task;

import com.hazelcast.client.impl.operations.OperationFactoryWrapper;
import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.task.AbstractAsyncMessageTask;
import com.hazelcast.instance.impl.Node;
import com.hazelcast.internal.namespace.NamespaceUtil;
import com.hazelcast.internal.nio.Connection;
import com.hazelcast.internal.util.collection.PartitionIdSet;
import com.hazelcast.map.impl.MapService;
import com.hazelcast.map.impl.MapServiceContext;
import com.hazelcast.map.impl.operation.MapOperationProvider;
import com.hazelcast.spi.impl.operationservice.OperationFactory;
import com.hazelcast.spi.impl.operationservice.OperationService;
import java.util.Map;
import java.util.concurrent.CompletableFuture;

public abstract class AbstractMultiPartitionMessageTask<P>
extends AbstractAsyncMessageTask<P, Map<Integer, Object>> {
    protected AbstractMultiPartitionMessageTask(ClientMessage clientMessage, Node node, Connection connection) {
        super(clientMessage, node, connection);
    }

    @Override
    protected void processMessage() {
        NamespaceUtil.runWithNamespace(this.nodeEngine, this.getUserCodeNamespace(), () -> super.processMessage());
    }

    @Override
    protected CompletableFuture<Map<Integer, Object>> processInternal() {
        OperationFactoryWrapper operationFactory = new OperationFactoryWrapper(this.createOperationFactory(), this.endpoint.getUuid());
        OperationService operationService = this.nodeEngine.getOperationService();
        return operationService.invokeOnPartitionsAsync(this.getServiceName(), (OperationFactory)operationFactory, this.getPartitions());
    }

    public abstract PartitionIdSet getPartitions();

    protected final MapOperationProvider getMapOperationProvider(String mapName) {
        MapService mapService = (MapService)this.getService("hz:impl:mapService");
        MapServiceContext mapServiceContext = mapService.getMapServiceContext();
        return mapServiceContext.getMapOperationProvider(mapName);
    }

    protected abstract String getUserCodeNamespace();

    protected abstract OperationFactory createOperationFactory();

    protected abstract Object reduce(Map<Integer, Object> var1);

    @Override
    protected Object processResponseBeforeSending(Map<Integer, Object> response) {
        return this.reduce(response);
    }
}

