/*
 * Decompiled with CFR 0.152.
 */
package net.messagevortex.commandline;

import java.io.File;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.Date;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.messagevortex.ExtendedSecureRandom;
import net.messagevortex.MessageVortexLogger;
import net.messagevortex.asn1.AsymmetricKey;
import net.messagevortex.asn1.IdentityStore;
import net.messagevortex.asn1.IdentityStoreBlock;
import net.messagevortex.asn1.UsagePeriod;
import net.messagevortex.asn1.encryption.Algorithm;
import net.messagevortex.asn1.encryption.AlgorithmType;
import net.messagevortex.asn1.encryption.DumpType;
import net.messagevortex.asn1.encryption.SecurityLevel;
import picocli.CommandLine;

@CommandLine.Command(description={"generate a new identity and dump store"}, name="generate", aliases={"gen"}, mixinStandardHelpOptions=true)
public class CommandLineHandlerIdentityStoreGenerate
implements Callable<Integer> {
    private static final Logger LOGGER = MessageVortexLogger.getLogger(new Throwable().getStackTrace()[0].getClassName());
    @CommandLine.Option(names={"--filename", "-f"}, description={"filename of the IdentityStorage file"})
    String filename = "identityStore.cfg";
    @CommandLine.Option(names={"--identityName", "-i"}, required=true, description={"name of the identity"})
    String identityId;

    @Override
    public Integer call() throws Exception {
        LOGGER.log(Level.INFO, "Generating new identity for \"" + this.identityId + "\"");
        IdentityStoreBlock isb = new IdentityStoreBlock();
        isb.setValid(new UsagePeriod(new Date(), new Date(new Date().getTime() * 3600L * 24L * 365L)));
        isb.setTransferQuota(ExtendedSecureRandom.nextInt(Integer.MAX_VALUE));
        isb.setMessageQuota(ExtendedSecureRandom.nextInt(Integer.MAX_VALUE));
        isb.setIdentityKey(new AsymmetricKey(Algorithm.getDefault(AlgorithmType.ASYMMETRIC).getParameters(SecurityLevel.QUANTUM)));
        isb.setNodeAddress("smtp:" + this.identityId);
        isb.setNodeKey(null);
        if (!new File(this.filename).exists()) {
            LOGGER.log(Level.SEVERE, "File \"" + this.filename + "\" not found");
            return 103;
        }
        LOGGER.log(Level.INFO, "Loading identity store \"" + this.filename + "\"");
        IdentityStore is = new IdentityStore(new File(this.filename));
        is.add(isb);
        LOGGER.log(Level.INFO, "Dumping identity store");
        System.out.println(is.dumpValueNotation("", DumpType.ALL_UNENCRYPTED));
        LOGGER.log(Level.INFO, "writing identity store to \"" + this.filename + "\"");
        try (OutputStream os = Files.newOutputStream(Paths.get(this.filename, new String[0]), new OpenOption[0]);){
            os.write(is.toBytes(DumpType.ALL_UNENCRYPTED));
        }
        LOGGER.log(Level.INFO, "finished");
        return 0;
    }
}

